### 实验名称

数据分析及实战

### 实验目的

1、通过对比2015至2017年主要城市年度数据的变化趋势，掌握数据可视化的基本流程和基本方法

2、掌握基于jupyternotebook工具的使用，python基本语法、pandas、numpy、matplotlib等模块应用

3、掌握数据加载、数据预处理、数据可视化等基本的数据分析流程

4、掌握基本的折线图、饼状图、直方图、柱形图、箱型图等基本数据图形显示

### 实验背景

1、通过对比2015年、2016年、2017年三年的主要城市数据变化，分别从国内生产总值、第一产业增加值、第二产业增加值、第三产业增加值、社会商品零售总额、货物进出口总额、年末总人口、在岗职工平均工资、普通高等学校在校学生数、医院卫生院数等十一个维度进行数据分析，实现对这三年各城市数据变化和发展趋势。

2、通过对比2015年、2016年、2017年三年的数据，探索36个省的第二产业增加值、年末总人口以及房地产开发投资额的变化情况。

### 实验原理

使用JupyterNotebook对数据进行处理和分析，涉及到python3的基础语法、pandas模块、numpy模块、matplotlib模块等python相关的数据分析库，各模块实现以下功能：

1，利用JupyterNotebook工具进行python3编程，函数定义、函数调用、显示图像数据。

2，通过pandas加载2015年、2016年、2017年三年的各大城市发展情况的数据，实现数据整合、拼接和缺失值处理。

3，通过matplotlib模块实现数据的折线图、饼状图、直方图等。

### 实验环境

Ubuntu 18.04

Python 3.9

jupyter notebook 6.1.0

pandas 2.0.3

matplotlib 3.7.2

numpy 1.25.2

### **建议课时**

2课时

### 实验步骤

#### 1、导入相关库

（1）、打开terminal终端，下载源数据

```markup
cd ~
wget http://10.90.3.2/HUP/DataMining/2024/02/data.zip
 
```

（2）、 解压数据包

```markup
unzip data.zip
```

（3）、启动jupyter

```markup
jupyter notebook
```

（4）、导入相关模块

```markup
import pandas as pd
import matplotlib.pyplot as plt
%matplotlib inline 
 
```

#### 2、数据加载

使用Python的pandas模块进行数据加载，示例代码如下：

```markup
df2015 = pd.read_csv('/home/ubuntu/data/2015_data.csv')
df2016 = pd.read_csv('/home/ubuntu/data/2016_data.csv')
df2017 = pd.read_csv('/home/ubuntu/data/2017_data.csv')
df2017.head()
 
```

![01_加载数据预览.png](./pic/01_加载数据预览.png)

#### 3、数据预处理

（1）、将三张表的数据拼接

```markup
df=pd.concat([df2015,df2016,df2017],axis=0)
```

（2）、重置列名，将中文列名置换为英文

```markup
df.index=[i for i in range(df.shape[0])]
df.columns=['area', 'year', 'total_value', 'one_value',  'two_value', 
            'three_value','zero_value', 'inout', 'population', 'pay', 
            'student', 'hospitalt', 'realty']
df.head()	

# 原列名与重置后的列名对应关系：
# area 			地区	
# year 			年份
# total_value 	国内生产总值
# one_value 		第一产业增加值	
# twol_value 		第二产业增加值	
# three_value 	第三产业增加值	
# zero_value 		社会商品零售总额	
# inout 			货物进出口总额	
# population 		年末总人口	
# pay 			在岗职工平均工资	
# student  		普通高等学校在校学生数	
# hospital 		医院、卫生院数	
# realty 			房地产开发投资额
 
```

![02_重置列名后数据.png](./pic/02_重置列名后数据.png)

（3）、判断数据缺失值

```markup
df.isnull().sum()
```

![03_判断缺失值.png](./pic/03_判断缺失值.png)

（4）、将realty列的均值填充

```markup
df['realty']=df['realty'].fillna(value=df['realty'].mean())
df.isnull().sum()
```

![04_均值填充.png](./pic/04_均值填充.png)

#### 4、设置图表属性

（1）、设置属性

```markup
#设置图像风格：
plt.style.use('ggplot') 

#设置字体格式及负值显示
plt.rcParams['font.sans-serif'] =['Microsoft YaHei']
plt.rcParams['axes.unicode_minus'] = False

#设置图像标题
plot_title = ['折线图1：国内生产总值', '折线图2：第一产业增加值', '折线图3：第二产业增加值', 
              '折线图4：第三产业增加值', '折线图5：社会商品零售总额', '折线图6：货物进出口总额', 
              '折线图7：在岗职工平均工资', '折线图8：普通高等学校在校学生数', '折线图9：医院、卫生院数', 
              '折线图10：房地产开发投资额']
 
```

（2）、提取各年份数据

```markup
#获取各年
dt2015 = df[df['year'] == 2015]
dt2016 = df[df['year'] == 2016]
dt2017 = df[df['year'] == 2017]
#定义列表
dataArr = ['area', 'total_value', 'one_value',  'two_value',  'three_value','zero_value', 'inout', 'pay', 'student', 'hospitalt', 'realty'] 	
 
```

#### 5、单图显示某项数据图

```markup
def plotType_one(data):
    #设置布画
    fig = plt.figure(figsize=(12,10))
    ax = fig.add_subplot()
    # 4-2、选择绘制线形图
    ax.plot(dt2015[data[0]], dt2015[data[1]], marker='o', label='2015')
    ax.plot(dt2016[data[0]], dt2016[data[1]], marker='o', label='2016')
    ax.plot(dt2017[data[0]], dt2017[data[1]], marker='o', label='2017')
    # 标题
    ax.set_title(plot_title[0])
    # 设置 X 轴刻度对应的标签 
    ax.set_xticklabels(labels=dt2015[data[0]], rotation=90)
    # 图例  
    ax.legend(loc='best')
         

#调用折线图函数显示数据
plotType_one(data=dataArr)
```

![05_折线图显示数据_1.png](./pic/05_折线图显示数据_1.png)

对各大城市的国内生产总值2015年至2017年三年数据进行可视化显示，从图中曲线呈现各大城市之间发展不均衡的情况。

#### 6、多图显示各项折线图

（1）、折线图函数及调用

```python
#定义折线图函数
def plotType(data):
    #设置布画
    fig = plt.figure(figsize=(3,10))
    for i in range(0, len(data) - 1):
        ax = fig.add_subplot(10, 1, i + 1)
        # 4-2、选择绘制线形图
        ax.plot(dt2015[data[0]], dt2015[data[i + 1]], marker='o', label='2015')
        ax.plot(dt2016[data[0]], dt2016[data[i + 1]], marker='o', label='2016')
        ax.plot(dt2017[data[0]], dt2017[data[i + 1]], marker='o', label='2017')
        # 标题
        ax.set_title(plot_title[i])
        # 设置 X 轴刻度对应的标签 
        ax.set_xticklabels(labels=dt2015[data[0]], rotation=90)
        # 图例  
        ax.legend(loc='best')
        # 调整子图之间间隙  
        fig.subplots_adjust(top=5, bottom=2, left=0.9, right= 3.6, hspace=1, wspace=1)  

#调用折线图函数显示数据
plotType(data=dataArr)
 
```

![05_折线图显示数据.png](./pic/05_折线图显示数据.png)

由以上折线图分析得出：在国内生产总值指标中， 北京、上海、广州、深圳、重庆占据绝对优势 ，太原、呼和浩特、海口、西宁倒数，占比最小；在第一、二、三产业指标中， 第一、第二产业龙头是重庆 ，第二、三产业龙头则是北京、上海、广州、深圳；在零售总额指标中，北京、上海、广州、深圳、重庆仍然占据绝对优势；在货物进出口指标中， 北京、上海、广州、深圳的占比明显比各省领先很多 ，其他省份普遍较低。

（2）、饼状图函数及调用

```markup
#重新设置图像标题
plot_title = ['饼状图1：国内生产总值', '饼状图2：第一产业增加值', '饼状图3：第二产业增加值', 
              '饼状图4：第三产业增加值', '饼状图5：社会商品零售总额', '饼状图6：货物进出口总额', 
              '饼状图7：在岗职工平均工资', '饼状图8：普通高等学校在校学生数', '饼状图9：医院、卫生院数', 
              '饼状图10：房地产开发投资额']
```

```markup
#定义饼状图函数
def pieType(data):
    #设置布画
    fig = plt.figure(figsize=(1,8))
    for i in range(0, len(data) - 1):
        ax = fig.add_subplot(10, 1, i + 1)
        ax.pie(x=dt2015[data[i + 1]], labels=dt2015[data[0]], shadow=True,autopct='%1.1f%%',pctdistance=0.9, radius=2.8)
        # 标题
        ax.set_title(plot_title[i],y=1.8) 
        # 设置标题的位置（位置编码）
        #ax.legend(loc='right')  # 图例
        # 调整子图间距,上下左右
        fig.subplots_adjust(top=10, bottom=0.1, left=0.9, right= 3.6, hspace=1, wspace=0) 

#调用饼状图函数显示数据
pieType(data=dataArr)
```

![06_饼状图显示数据.png](./pic/06_饼状图显示数据.png)

由以上饼状图分析得出：在平均工资指标中，北京、上海、广州、深圳及拉萨占比较大；在校学生数指标中， 宁夏、厦门、深圳、海口、拉萨、西宁、银川占比最小 ，深圳虽然是一线城市，但是大学学校不多；在医院数指标中，重庆、成都占比较大；在房地产投资指标中，北京、上海、杭州、郑州、广州、重庆、西安占比较大。

### 实验总结

本项目主要内容是使用jupyterNotebook对近三年各大城市数据进行分析，首先用pandas对数据合并后做缺失值处理，其次将中文列名置换为英文列名，定义并绘制折线图、饼状图等图像，最后通过图像可视化库matplotlib将分析的数据进行可视化。通过实操能够熟悉python编写数据分析过程，熟悉数据分析常用的模块pandas、numpy以及matplotlib模块，掌握了数据分析的基本方法，能够使用matplotlib进行数据可视化。